/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.traits.abilities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.Trinkets;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.magic.MagicStats;
import xzeroair.trinkets.client.events.ScreenOverlayEvents;
import xzeroair.trinkets.client.keybinds.ModKeyBindings;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.network.particles.EffectsRenderPacket;
import xzeroair.trinkets.traits.abilities.Ability;
import xzeroair.trinkets.traits.abilities.interfaces.IKeyBindInterface;
import xzeroair.trinkets.traits.abilities.interfaces.ITickableAbility;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.lycanitesmobs.LycanitesCompat;
import xzeroair.trinkets.util.handlers.Counter;
import xzeroair.trinkets.util.helpers.RayTraceHelper;
import xzeroair.trinkets.util.helpers.StringUtils;

public class AbilityLightningBolt
extends Ability
implements ITickableAbility,
IKeyBindInterface {
    protected Predicate<Entity> Targets = Predicates.and((Predicate)EntitySelectors.field_180132_d, ent -> ent != null && ent.func_70067_L());

    public AbilityLightningBolt() {
        super("lightning_bolt");
    }

    @Override
    public void tickAbility(EntityLivingBase entity) {
        LycanitesCompat.removeParalysis(entity);
    }

    protected boolean prepareBolt(EntityLivingBase entity, MagicStats magic, boolean def, boolean aux) {
        float cfgCost = TrinketsConfig.SERVER.Items.ARCING_ORB.attackCost;
        int length = Math.min((int)(300.0 * Math.min(MathHelper.func_181160_c((double)magic.getMana(), (double)0.0, (double)cfgCost), 1.0)), 300);
        Counter counter = this.tickHandler.getCounter("heldCounter", length, false, true, false, true, false);
        counter.setLength(length);
        return def;
    }

    protected boolean chargeBolt(EntityLivingBase entity, MagicStats magic, boolean def, boolean aux) {
        float cfgCost = TrinketsConfig.SERVER.Items.ARCING_ORB.attackCost;
        float maxMP = magic.getMaxMana();
        float mp = magic.getMana();
        Counter counter = this.tickHandler.getCounter("heldCounter");
        int tick = counter.getTick();
        float multi = (float)MathHelper.func_181160_c((double)tick, (double)0.0, (double)counter.getLength());
        float realCost = (float)((double)cfgCost * MathHelper.func_181160_c((double)tick, (double)0.0, (double)300.0));
        if (!counter.Tick()) {
            if (entity instanceof EntityPlayer && entity.field_70170_p.field_72995_K) {
                entity.field_70170_p.func_184133_a((EntityPlayer)entity, entity.func_180425_c(), SoundEvents.field_187679_dF, SoundCategory.PLAYERS, 0.5f, (float)StringUtils.getAccurateDouble(Math.min(0.6f + 0.4f * multi, 1.0f)));
                ScreenOverlayEvents.instance.SyncCost(realCost);
            }
            if (realCost == mp) {
                return false;
            }
        } else {
            if (entity instanceof EntityPlayer && entity.field_70170_p.field_72995_K) {
                entity.field_70170_p.func_184133_a((EntityPlayer)entity, entity.func_180425_c(), SoundEvents.field_187598_bd, SoundCategory.PLAYERS, 0.5f, 0.5f);
                ScreenOverlayEvents.instance.SyncCost(realCost);
            }
            return false;
        }
        return def;
    }

    protected boolean castBolt(EntityLivingBase entity, MagicStats magic, boolean def, boolean aux) {
        float cfgCost = TrinketsConfig.SERVER.Items.ARCING_ORB.attackCost;
        float cfgDmg = TrinketsConfig.SERVER.Items.ARCING_ORB.attackDmg;
        float maxMP = magic.getMaxMana();
        float mp = magic.getMana();
        Counter counter = this.tickHandler.getCounter("heldCounter");
        int tick = counter.getTick();
        float multi = (float)MathHelper.func_181160_c((double)tick, (double)0.0, (double)300.0);
        float realCost = (float)StringUtils.getAccurateDouble(cfgCost * multi);
        if ((double)tick > (double)counter.getLength() * 0.1) {
            float finalDamage = cfgDmg * multi;
            if (magic.spendMana(realCost)) {
                double maxDist = 15.0;
                Vec3d start = entity.func_174824_e(1.0f);
                Vec3d lookVec = entity.func_70040_Z();
                Vec3d end = start.func_72441_c(lookVec.field_72450_a * 15.0, lookVec.field_72448_b * 15.0, lookVec.field_72449_c * 15.0);
                RayTraceResult result = RayTraceHelper.rayTrace(entity, 15.0);
                Vec3d hitLoc = end;
                if (result != null) {
                    if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
                        Entity hit = result.field_72308_g;
                        hitLoc = result.field_72307_f.func_72441_c(0.0, (double)(hit.field_70131_O * 0.5f), 0.0);
                    } else if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                        hitLoc = result.field_72307_f;
                    }
                }
                if (Trinkets.proxy.getSide() == Side.CLIENT) {
                    NetworkHandler.sendToServer(new EffectsRenderPacket((Entity)entity, start.field_72450_a, start.field_72448_b, start.field_72449_c, hitLoc.field_72450_a, hitLoc.field_72448_b, hitLoc.field_72449_c, 2515356, 1, 0.9f, 3.0f));
                    NetworkHandler.sendToServer(new EffectsRenderPacket((Entity)entity, hitLoc.field_72450_a, hitLoc.field_72448_b, hitLoc.field_72449_c, hitLoc.field_72450_a, hitLoc.field_72448_b, hitLoc.field_72449_c, 2515356, 2, 0.9f, 3.0f));
                }
                if (!entity.func_130014_f_().field_72995_K) {
                    boolean pvpEnabled = false;
                    try {
                        if (entity instanceof EntityPlayerMP) {
                            pvpEnabled = ((EntityPlayerMP)entity).func_184102_h().func_71219_W();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    AxisAlignedBB bb1 = new AxisAlignedBB(new BlockPos(hitLoc)).func_186662_g(1.0);
                    List splash = entity.field_70170_p.func_175674_a((Entity)entity, bb1, this.Targets);
                    for (Entity e : splash) {
                        if (e instanceof EntityPlayer && !pvpEnabled) continue;
                        if (multi > 0.33f && e instanceof EntityCreeper) {
                            EntityCreeper creep = (EntityCreeper)e;
                            EntityLightningBolt bolt = new EntityLightningBolt(entity.func_130014_f_(), creep.field_70165_t, creep.field_70163_u, creep.field_70161_v, true);
                            creep.func_70077_a(bolt);
                            creep.func_70066_B();
                        }
                        e.func_70097_a((DamageSource)new EntityDamageSource("lightningBolt", (Entity)entity), finalDamage);
                    }
                }
                this.reset((Entity)entity);
                return true;
            }
        }
        this.reset((Entity)entity);
        return def;
    }

    protected void reset(Entity entity) {
        Counter counter = this.tickHandler.getCounter("heldCounter");
        if (counter != null) {
            counter.resetTick();
            counter.setLength(300);
        }
        if (entity.field_70170_p.field_72995_K) {
            ScreenOverlayEvents.instance.SyncCost(0.0f);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getKey() {
        return ModKeyBindings.ARCING_ORB_ABILITY.getDisplayName();
    }

    @Override
    public boolean onKeyPress(Entity entity, boolean Aux) {
        return Capabilities.getMagicStats(entity, true, (magic, ret) -> this.prepareBolt((EntityLivingBase)entity, (MagicStats)magic, (boolean)ret, Aux));
    }

    @Override
    public boolean onKeyDown(Entity entity, boolean Aux) {
        return Capabilities.getMagicStats(entity, true, (magic, ret) -> this.chargeBolt((EntityLivingBase)entity, (MagicStats)magic, (boolean)ret, Aux));
    }

    @Override
    public boolean onKeyRelease(Entity entity, boolean Aux) {
        return Capabilities.getMagicStats(entity, true, (magic, ret) -> this.castBolt((EntityLivingBase)entity, (MagicStats)magic, (boolean)ret, Aux));
    }
}

